import sys
input = sys.stdin.readline

n = int(input())
x = list(map(int, input().split()))
h = list(map(int, input().split()))

# sortiramo po x (nije garantovano da su sortirani)
pts = sorted(zip(x, h))
x = [p[0] for p in pts]
h = [p[1] for p in pts]

# transformacija
# u = x + h
# v = x - h
u = [x[i] + h[i] for i in range(n)]
v = [x[i] - h[i] for i in range(n)]

# gradimo gornju omotacnicu u (u, v) prostoru
hull = []

def bad(a, b, c):
    # proverava da li je b suvišan izmedu a i c
    return (b[1] - a[1]) * (c[0] - b[0]) >= (c[1] - b[1]) * (b[0] - a[0])

for i in range(n):
    p = (u[i], v[i], i)
    while len(hull) >= 2 and bad(hull[-2], hull[-1], p):
        hull.pop()
    hull.append(p)

# priprema za binarnu pretragu
hu = [p[0] for p in hull]
hv = [p[1] for p in hull]

INF = 10**30
ans = [INF] * n

import bisect

for i in range(n):
    ui = u[i]
    vi = v[i]

    pos = bisect.bisect_left(hu, ui)

    for j in (pos - 1, pos):
        if 0 <= j < len(hull):
            uj, vj, idx = hull[j]
            # visina te tacke
            y = (uj - vj) // 2
            if y >= h[i]:
                dist = abs(x[idx] - x[i]) + abs(h[idx] - h[i])
                ans[i] = min(ans[i], dist)

# ispis
out = []
for v in ans:
    if v == INF:
        out.append("-1")
    else:
        out.append(str(v))

print("\n".join(out))